#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using AUDITTRAILTYPE  =  gov.va.med.vbecs.BOL.AuditTrail.AuditTrailConst.AuditTrailType;

#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_AuditTrail : BaseTest 
	{
		private System.DateTime _startDate  =  System.DateTime.Today;
		private System.DateTime _endDate  =  System.DateTime.Today.AddDays(5);
		private System.DateTime _invalidStart  =  System.DateTime.Today.AddYears(1);
		private System.DateTime _invalidEnd  =  System.DateTime.Today.AddYears(-1);
		private System.Collections.ArrayList _cleanupSQL;

		private BOL.AuditTrail _testAudit;
		

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._endDate  =  System.DateTime.Today.AddDays(5);
				this.RefreshData = false;
			}
			
			VistALinkUnitTestHarness.RequireConnection();

			this._testAudit  =  new BOL.AuditTrail(this._startDate, this._endDate);
		}

		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.ReleaseConnection();
		}

		[Test]
		public void Ctor_Success()
		{
			Assert.IsTrue(this._testAudit.StartDate.Date == this._startDate.Date);
			Assert.IsTrue(this._testAudit.AuditReportData.Columns.Count == 8);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}


		[Test]
		public void AuditReportData_Success()
		{
			Assert.IsTrue(this._testAudit.AuditReportData.TableName == "AuditReport");
			Assert.IsTrue(this._testAudit.AuditReportData.Columns.Count == 8);
			Assert.IsTrue(this._testAudit.AuditReportData.Columns.Contains(ARTIFICIAL.AuditIdentifier));
			Assert.IsTrue(this._testAudit.AuditReportData.Columns.Contains(ARTIFICIAL.AuditType));
			Assert.IsTrue(this._testAudit.AuditReportData.Columns.Contains(ARTIFICIAL.ChangedFieldName));
			Assert.IsTrue(this._testAudit.AuditReportData.Columns.Contains(ARTIFICIAL.OldValue));
			Assert.IsTrue(this._testAudit.AuditReportData.Columns.Contains(ARTIFICIAL.NewValue));
			Assert.IsTrue(this._testAudit.AuditReportData.Columns.Contains(ARTIFICIAL.AuditUser));
			Assert.IsTrue(this._testAudit.AuditReportData.Columns.Contains(ARTIFICIAL.AuditDate));
			Assert.IsTrue(this._testAudit.AuditReportData.Columns.Contains(ARTIFICIAL.Comment));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AuditReportData_Fail()
		{
		}


		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAuditTrailReport_Fail()
		{
		}

		[Test]
		public void Cstor_Empty_Pass()
		{
			BOL.AuditTrail tmpAt = new AuditTrail();

			tmpAt.StartDate = DateTime.Today.AddDays(-10);
			tmpAt.EndDate = DateTime.Today;
			
			Assert.IsNotNull(tmpAt);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Cstor_Empty_Fail()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GenerateAndPrintReport_Pass()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GenerateAndPrintReport_Fail()
		{
		}


		[Test]
		public void GetAuditTrailReport_Success()
		{
			try
			{
				DataRow drData;
				System.Guid recGuid;
				this._cleanupSQL  =  new System.Collections.ArrayList();

				//Data for GetPatientAuditReport()
				recGuid  =  DataCreator.GetRecordGuid("SELECT TOP 1 PatientGuid FROM Patient");
				this.PerformUpdate(TABLES.Patient.TableName, TABLES.Patient.PatientGuid, recGuid, "PatientLastName  =  'StoolSample'");
				this._cleanupSQL.Add("UPDATE Patient SET PatientLastName  =  'CrickaCracka' WHERE PatientGuid  =  '" + recGuid.ToString() + "'");

				//Data for GetTRAuditReport()
				recGuid  =  DataCreator.GetRecordGuid("SELECT TOP 1 PatientTransfusionRequirementGuid FROM PatientTransfusionRequirement WHERE RecordStatusCode  =  'A' AND CreateDivisionCode  =  '" + Common.LogonUser.LogonUserDivisionCode + "'");
				this.PerformUpdate(TABLES.PatientTransfusionRequirement.TableName, TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid, recGuid, "RecordStatusCode  =  'X'");
				this._cleanupSQL.Add("UPDATE PatientTransfusionRequirement SET RecordStatusCode  =  'A' WHERE PatientTransfusionRequirementGuid  =  '" + recGuid.ToString() + "'");


				//Data for GetBloodUnitFinanceAuditReport()
				recGuid  =  DataCreator.GetRecordGuid("SELECT TOP 1 BloodUnitFinanceGuid FROM BloodUnitFinance JOIN BloodUnit ON BloodUnit.BloodUnitGuid  =  BloodUnitFinance.BloodUnitGuid WHERE BloodUnit.DivisionCode  =  '" + Common.LogonUser.LogonUserDivisionCode + "'");
				this.PerformUpdate(TABLES.BloodUnitFinance.TableName, TABLES.BloodUnitFinance.BloodUnitFinanceGuid, recGuid, "SpecialTestingCost  =  98.54");
				this._cleanupSQL.Add("UPDATE BloodUnitFinance SET SpecialTestingCost  =  97.43 WHERE BloodUnitFinanceGuid  =  '" + recGuid.ToString() + "'");


				//Data for GetLocalSupplierAuditReport() 
				recGuid  =  DataCreator.GetRecordGuid("SELECT TOP 1 LocalSupplierGuid FROM LocalSupplier WHERE DivisionCode  =  '" + Common.LogonUser.LogonUserDivisionCode + "'");
				this.PerformUpdate(TABLES.LocalSupplier.TableName, TABLES.LocalSupplier.LocalSupplierGuid, recGuid, "FacilityName  =  'I.P. Freely Depot'");
				this._cleanupSQL.Add("UPDATE LocalSupplier SET FacilityName  =  'HokeyPokey' WHERE LocalSupplierGuid  =  '" + recGuid.ToString() + "'");

//				//Data for GetBloodProductAuditReport() 
//				recGuid  =  DataCreator.GetRecordGuid("SELECT TOP 1 BloodProductGuid FROM DivisionSiteParameter WHERE SiteParameterActiveIndicator  =  1 AND DivisionCode  =  '" + Common.LogonUser.LogonUserDivisionCode + "'");
//				this.PerformUpdate(DIVISIONSITEPARAMETER.TableName, TABLES.BloodProduct.BloodProductGuid, recGuid, "SiteParameterActiveIndicator  =  0");			
//				this._cleanupSQL.Add("UPDATE DivisionSiteParameter SET SiteParameterActiveIndicator  =  1 WHERE BloodProductGuid  =  '" + recGuid.ToString() + "'");


				//Data for GetDivisionAuditReport()
				UnitTestUtil.RunSQL("UPDATE VamcDivision SET DivisionName  =  'Bent My Wookie',  LastUpdateDate  =  GETUTCDATE(), LastUpdateUser  =  '" + Common.LogonUser.LogonUserName + "' WHERE DivisionCode  =  '" + Common.LogonUser.LogonUserDivisionCode + "'");
				this._cleanupSQL.Add("UPDATE VamcDivision SET DivisionName  =  'Thats Unpossible' WHERE DivisionCode  =  '" + UnitTestConfig.TestDivisionCode + "'");


				//Data for GetProductModificationParameterAuditReport()
				recGuid  =  DataCreator.GetRecordGuid("SELECT TOP 1 ProductModificationParameterGuid FROM ProductModificationParameter WHERE RecordStatusCode  =  'A' AND DivisionCode  =  '" + Common.LogonUser.LogonUserDivisionCode + "'");
				this.PerformUpdate(TABLES.ProductModificationParameter.TableName, TABLES.ProductModificationParameter.ProductModificationParameterGuid, recGuid, "RecordStatusCode  =  'X'");			
				this._cleanupSQL.Add("UPDATE ProductModificationParameter SET RecordStatusCode  =  'A' WHERE ProductModificationParameterGuid  =  '" + recGuid.ToString() + "'");


				//Data for GetAntibodyAuditReport()
				recGuid  =  DataCreator.GetRecordGuid("SELECT TOP 1 AntibodyParameterGuid FROM AntibodyParameter WHERE DivisionCode  =  '" + Common.LogonUser.LogonUserDivisionCode + "'");
				this.PerformUpdate(TABLES.AntibodyParameter.TableName, TABLES.AntibodyParameter.AntibodyParameterGuid, recGuid, "CompatibilityPercentage  =  71");			
				this._cleanupSQL.Add("UPDATE AntibodyParameter SET CompatibilityPercentage  =  59 WHERE AntibodyParameterGuid  =  '" + recGuid.ToString() + "'");


				//Data for GetWorkloadAuditReport()
				recGuid  =  DataCreator.GetRecordGuid("SELECT TOP 1 WorkloadProcessGuid FROM WorkloadProcess WHERE RecordStatusCode  =  'A' AND DivisionCode  =  '" + Common.LogonUser.LogonUserDivisionCode + "'");
				this.PerformUpdate(TABLES.WorkloadProcess.TableName, TABLES.WorkloadProcess.WorkloadProcessGuid, recGuid, "RecordStatusCode  =  'X'");			
				this._cleanupSQL.Add("UPDATE WorkloadProcess SET RecordStatusCode  =  'A' WHERE WorkloadProcessGuid  =  '" + recGuid.ToString() + "'");


				//Data for GetMSBOSAuditReport()
				recGuid  =  DataCreator.GetRecordGuid("SELECT TOP 1 MsbosGuid FROM MSBOS WHERE RecordStatusCode  =  'A' AND DivisionCode  =  '" + Common.LogonUser.LogonUserDivisionCode + "'");
				this.PerformUpdate(TABLES.Msbos.TableName, TABLES.Msbos.MsbosGuid, recGuid, "RecordStatusCode  =  'X'");			
				this._cleanupSQL.Add("UPDATE MSBOS SET RecordStatusCode  =  'A' WHERE MsbosGuid  =  '" + recGuid.ToString() + "'");


				//Data for GetTransfusionEffectivenessAuditReport()
				recGuid  =  DataCreator.GetRecordGuid("SELECT TOP 1 SpecimenTestThresholdGuid FROM SpecimenTestThreshold WHERE ReportTypeID  =  8 AND SpecimenTestThreshold.RecordStatusCode  =  'A' AND SpecimenTestThreshold.DivisionCode  =  '" + Common.LogonUser.LogonUserDivisionCode + "'");
				this.PerformUpdate(TABLES.SpecimenTestThreshold.TableName, TABLES.SpecimenTestThreshold.SpecimenTestThresholdGuid, recGuid, "RecordStatusCode  =  'X'");			
				this._cleanupSQL.Add("UPDATE SpecimenTestThreshold SET RecordStatusCode  =  'A' WHERE SpecimenTestThresholdGuid  =  '" + recGuid.ToString() + "'");


				//Data for GetTransfusionComplicationsAuditReport()
				recGuid  =  DataCreator.GetRecordGuid("SELECT TOP 1 SpecimenTestThresholdGuid FROM SpecimenTestThreshold WHERE ReportTypeID  =  7 AND SpecimenTestThreshold.RecordStatusCode  =  'A' AND SpecimenTestThreshold.DivisionCode  =  '" + Common.LogonUser.LogonUserDivisionCode + "'");
				this.PerformUpdate(TABLES.SpecimenTestThreshold.TableName, TABLES.SpecimenTestThreshold.SpecimenTestThresholdGuid, recGuid, "RecordStatusCode  =  'X'");			
				this._cleanupSQL.Add("UPDATE SpecimenTestThreshold SET RecordStatusCode  =  'A' WHERE SpecimenTestThresholdGuid  =  '" + recGuid.ToString() + "'");

				//Data for GetComponentClassAuditReport()
				recGuid  =  DataCreator.GetRecordGuid("SELECT TOP 1 ComponentClassParameterGuid FROM ComponentClassParameter WHERE RecordStatusCode  =  'A' AND DivisionCode  =  '" + Common.LogonUser.LogonUserDivisionCode + "'");
				this.PerformUpdate(TABLES.ComponentClassParameter.TableName, TABLES.ComponentClassParameter.ComponentClassParameterGuid, recGuid, "MaximumTransfusionTime  =  674");
				this._cleanupSQL.Add("UPDATE ComponentClassParameter SET MaximumTransfusionTime  =  187 WHERE ComponentClassParameterGuid  =  '" + recGuid.ToString() + "'");


				//Data for GetDailyControlAuditReport()
				recGuid  =  DataCreator.GetRecordGuid("SELECT TOP 1 DailyControlGuid FROM DailyControl WHERE CommercialTemplateIndicator  =  0 AND DivisionCode  =  '" + Common.LogonUser.LogonUserDivisionCode + "'");
				this.PerformUpdate(TABLES.DailyControl.TableName, TABLES.DailyControl.DailyControlGuid, recGuid, "CommercialTemplateIndicator  =  1");
				this._cleanupSQL.Add("UPDATE DailyControl SET CommercialTemplateIndicator  =  0 WHERE DailyControlGuid  =  '" + recGuid.ToString() + "'");

				UnitTestUtil.RunSQL("UPDATE ReagentTestParameter SET DailyUseIndicator  =  1, LastUpdateDate  =  GetUTCDate(), TestWithName  =  'Bartman', LastUpdateUser  =  '" + Common.LogonUser.LogonUserName + "' WHERE ReagentTypeId < 40 AND DailyUseIndicator  =  0 AND DivisionCode  =  '" + UnitTestConfig.TestDivisionCode + "'");
				this._cleanupSQL.Add("UPDATE ReagentTestParameter SET DailyUseIndicator  =  0, TestWithName  =  'HomerJSimpsons', LastUpdateUser  =  'HomerJSimpson' WHERE DivisionCode  =  '" + UnitTestConfig.TestDivisionCode + "' AND ReagentTypeId < 40 AND DailyUseIndicator  =  1");

				//Data for GetConfigureTestingAuditReport()
				drData  =  UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM VamcDivision WHERE DivisionCode  =  '" + Common.LogonUser.LogonUserDivisionCode + "'");
				int newCode  =  0;
				int oldCode  =  System.Convert.ToInt32(drData[TABLES.VamcDivision.AntibodyScreenDisplayCode]);
				if (oldCode  ==  1) newCode  =  2;
				if (oldCode  ==  2) newCode  =  3;
				if (oldCode  ==  3) newCode  =  1;
				UnitTestUtil.RunSQL("UPDATE VamcDivision SET AntibodyScreenDisplayCode  =  " + newCode.ToString() + ", LastUpdateDate  =  GETUTCDATE(), LastUpdateUser  =  '" + Common.LogonUser.LogonUserName + "' WHERE DivisionCode  =  '" + UnitTestConfig.TestDivisionCode + "'");
				this._cleanupSQL.Add("UPDATE VamcDivision SET AntibodyScreenDisplayCode  =  " + oldCode.ToString() + " WHERE DivisionCode  =  '" + UnitTestConfig.TestDivisionCode + "'");


				//Data for GetReagentTypeParameterAuditReport()
				recGuid  =  DataCreator.GetRecordGuid("SELECT TOP 1 ReagentTypeParameterGuid FROM ReagentTypeParameter WHERE DivisionCode  =  '" + Common.LogonUser.LogonUserDivisionCode + "'");
				this.PerformUpdate(TABLES.ReagentTypeParameter.TableName, TABLES.ReagentTypeParameter.ReagentTypeParameterGuid, recGuid, "MinimumStockLevel  =  42");
				this._cleanupSQL.Add("UPDATE ReagentTypeParameter SET MinimumStockLevel  =  89 WHERE ReagentTypeParameterGuid  =  '" + recGuid.ToString() + "'");


				//Data for GetUserAlertsAuditReport
				UnitTestUtil.RunSQL("UPDATE VamcDivision SET PrinterAlertsPrinterName  =  'ChumbaWumba', LastUpdateDate  =  GETUTCDATE(), LastUpdateUser  =  '" + Common.LogonUser.LogonUserName + "' WHERE DivisionCode  =  '" + UnitTestConfig.TestDivisionCode + "'");
				this._cleanupSQL.Add("UPDATE VamcDivision SET PrinterAlertsPrinterName  =  'Hii Everybody' WHERE DivisionCode  =  '" + UnitTestConfig.TestDivisionCode + "'");

				//Data for GetBloodUnitStatusAuditReport()
				recGuid  =  DataCreator.GetRecordGuid("SELECT TOP 1 BloodUnitStatusGuid FROM BloodUnitStatus JOIN BloodUnit ON BloodUnit.BloodUnitGuid  =  BloodUnitStatus.BloodUnitGuid WHERE UnitStatusCode  =  'A' AND BloodUnit.DivisionCode  =  '" + Common.LogonUser.LogonUserDivisionCode + "'");
				this.PerformUpdate(TABLES.BloodUnitStatus.TableName, TABLES.BloodUnitStatus.BloodUnitStatusGuid, recGuid, "UnitStatusCode  =  'X'");
				this._cleanupSQL.Add("UPDATE BloodUnitStatus SET UnitStatusCode  =  'A' WHERE BloodUnitStatusGuid  =  '" + recGuid.ToString() + "'");


				//Data for GetBloodUnitAuditReport()
				recGuid  =  DataCreator.GetRecordGuid("SELECT TOP 1 BloodUnitGuid FROM BloodUnit WHERE RecordStatusCode  =  'A' AND DivisionCode  =  '" + Common.LogonUser.LogonUserDivisionCode + "'");
				this.PerformUpdate(TABLES.BloodUnit.TableName, TABLES.BloodUnit.BloodUnitGuid, recGuid, "RecordStatusCode  =  'X'");
				this._cleanupSQL.Add("UPDATE BloodUnit SET RecordStatusCode  =  'A' WHERE BloodUnitGuid  =  '" + recGuid.ToString() + "'");


				//Data for GetBloodUnitMediaAuditReport()
				drData  =  UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM BloodUnitMedia JOIN BloodUnit ON BloodUnit.BloodUnitGuid  =  BloodUnitMedia.BloodUnitGuid WHERE DirectedPatientGuid IS NOT NULL AND BloodUnit.DivisionCode  =  '" + Common.LogonUser.LogonUserDivisionCode + "'");
				recGuid  =  (System.Guid)drData[TABLES.BloodUnitMedia.BloodUnitMediaGuid];
				this.PerformUpdate(TABLES.BloodUnitMedia.TableName, TABLES.BloodUnitMedia.BloodUnitMediaGuid, recGuid, "DirectedPatientGuid  =  NULL");
				this._cleanupSQL.Add("UPDATE BloodUnitMedia SET DirectedPatientGuid  =  '" + drData[TABLES.BloodUnitMedia.DirectedPatientGuid].ToString() + "' WHERE BloodUnitMediaGuid  =  '" + recGuid.ToString() + "'");


				//Data for GetBloodUnitAntigenAuditReport()
				UnitTestUtil.RunSQL("UPDATE BloodUnitAntigen SET RecordStatusCode  =  'E', LastUpdateDate  =  GETUTCDATE(), LastUpdateUser  =  '" + Common.LogonUser.LogonUserName + "' WHERE AntigenTypeId  =  1 AND RecordStatusCode  =  'A' AND DivisionCode  =  '" + UnitTestConfig.TestDivisionCode + "'");
				this._cleanupSQL.Add("UPDATE BloodUnitAntigen SET RecordStatusCode  =  'A' WHERE RecordStatusCode  =  'E' AND DivisionCode  =  '" + UnitTestConfig.TestDivisionCode + "'");


				//Data for GetBloodUnitTestAuditReport()
				recGuid  =  DataCreator.GetRecordGuid("SELECT TOP 1 BloodUnitTestGuid FROM BloodUnitTest JOIN BloodTestType ON BloodTestType.BloodTesttypeID  =  BloodUnitTest.BloodTestTypeId WHERE BloodTestType.BloodTestName LIKE '%Interp' AND BloodUnitTest.BloodTestTypeId NOT IN (102,104) AND BloodUnitTest.RecordStatusCode  =  'A' AND BloodUnitTest.DivisionCode  =  '" + Common.LogonUser.LogonUserDivisionCode + "'");
				this.PerformUpdate(TABLES.BloodUnitTest.TableName, TABLES.BloodUnitTest.BloodUnitTestGuid, recGuid, "RecordStatusCode  =  'E'");
				this._cleanupSQL.Add("UPDATE BloodUnitTest SET RecordStatusCode  =  'A' WHERE BloodUnitTestGuid  =  '" + recGuid.ToString() + "'");


				//Data for GetUserRoleAuditReport()
				UnitTestUtil.RunSQL("UPDATE VbecsUserDivisionRole SET UserRoleId  =  2, LastUpdateDate  =  GETUTCDATE(), LastUpdateUser  =  '" + Common.LogonUser.LogonUserName + "' WHERE UserRoleId  =  6 AND DivisionCode  =  '" + UnitTestConfig.TestDivisionCode + "'");
				this._cleanupSQL.Add("UPDATE VbecsUserDivisionRole SET UserRoleId  =  6 WHERE UserRoleId  =  2 AND DivisionCode  =  '" + UnitTestConfig.TestDivisionCode + "'");


				//Data for GetInterfaceControlAuditReport()
				UnitTestUtil.RunSQL("UPDATE InterfaceControl SET AckTimeout  =  17, LastUpdateDate  =  GETUTCDATE(), LastUpdateUser  =  '" + Common.LogonUser.LogonUserName + "' WHERE InterfaceFacilityId  =  '" + UnitTestConfig.TestDivisionCode + "'");
				this._cleanupSQL.Add("UPDATE InterfaceControl SET AckTimeout  =  31 WHERE InterfaceFacilityId  =  '" + UnitTestConfig.TestDivisionCode + "'");


				//Data for GetSpecimenTestAuditReport()
				recGuid  =  DataCreator.GetRecordGuid("SELECT TOP 1 SpecimenTestGuid FROM SpecimenTest WHERE AboRhChangeIndicator  =  0 AND DivisionCode  =  '" + Common.LogonUser.LogonUserDivisionCode + "'");
				this.PerformUpdate(TABLES.SpecimenTest.TableName, TABLES.SpecimenTest.SpecimenTestGuid, recGuid, "AboRhChangeIndicator  =  1");
				this._cleanupSQL.Add("UPDATE SpecimenTest SET AboRhChangeIndicator  =  0 WHERE SpecimenTestGuid  =  '" + recGuid.ToString() + "'");

			}
			catch
			{
				//Cleanup the data first -- in case we fail
				for (int ndx = 0; ndx < this._cleanupSQL.Count; ndx++)
				{
					UnitTestUtil.RunSQL(this._cleanupSQL[ndx].ToString());
				}
			}


			DataSet dsTest  =  this._testAudit.GetAuditTrailReport();

			//Cleanup the data first -- in case we fail
			for (int ndx = 0; ndx < this._cleanupSQL.Count; ndx++)
			{
				UnitTestUtil.RunSQL(this._cleanupSQL[ndx].ToString());
			}

			Assert.IsTrue(dsTest.Tables.Count == 2);
			DataTable dtTest  =  this._testAudit.AuditReportData;
			int rCount  =  dtTest.Rows.Count;

			Assert.IsTrue(dsTest.Tables[0].TableName == "AuditReport","Table0 Name");
			Assert.IsTrue(dsTest.Tables[1].TableName == "PreliminaryAuditReport","Table1 Name");
			Assert.IsTrue(dsTest.Tables[0].Columns.Count  ==  8, "Column0 Count");
			Assert.IsTrue(dsTest.Tables[1].Columns.Count  ==  1, "Column1 Count");
			Assert.IsTrue(dsTest.Tables[0].Rows.Count > 0, "RowCount");

			//This validates audits happened
			Assert.IsTrue(dsTest.Tables[0].Select(ARTIFICIAL.AuditType + "  =  '" + AUDITTRAILTYPE.Antibody + "'").Length >=  0,AUDITTRAILTYPE.Antibody);
			Assert.IsTrue(dsTest.Tables[0].Select(ARTIFICIAL.AuditType + "  =  '" + AUDITTRAILTYPE.BloodProduct + "'").Length >=  0,AUDITTRAILTYPE.BloodProduct);
			Assert.IsTrue(dsTest.Tables[0].Select(ARTIFICIAL.AuditType + "  =  '" + AUDITTRAILTYPE.BloodUnit + "'").Length >=  0,AUDITTRAILTYPE.BloodUnit);
			Assert.IsTrue(dsTest.Tables[0].Select(ARTIFICIAL.AuditType + "  =  '" + AUDITTRAILTYPE.BloodUnitFinance + "'").Length >=  0,AUDITTRAILTYPE.BloodUnitFinance);
			Assert.IsTrue(dsTest.Tables[0].Select(ARTIFICIAL.AuditType + "  =  '" + AUDITTRAILTYPE.ComponentClass + "'").Length >=  0,AUDITTRAILTYPE.ComponentClass);
			Assert.IsTrue(dsTest.Tables[0].Select(ARTIFICIAL.AuditType + "  =  '" + AUDITTRAILTYPE.InterfaceControl + "'").Length >=  0, AUDITTRAILTYPE.InterfaceControl);
			Assert.IsTrue(dsTest.Tables[0].Select(ARTIFICIAL.AuditType + "  =  '" + AUDITTRAILTYPE.LocalSupplier + "'").Length >=  0, AUDITTRAILTYPE.LocalSupplier);
			Assert.IsTrue(dsTest.Tables[0].Select(ARTIFICIAL.AuditType + "  =  '" + AUDITTRAILTYPE.MaintainDivision + "'").Length >=  0, AUDITTRAILTYPE.MaintainDivision);
			Assert.IsTrue(dsTest.Tables[0].Select(ARTIFICIAL.AuditType + "  =  '" + AUDITTRAILTYPE.MaintainUser + "'").Length >=  0, AUDITTRAILTYPE.MaintainUser);
			Assert.IsTrue(dsTest.Tables[0].Select(ARTIFICIAL.AuditType + "  =  '" + AUDITTRAILTYPE.MSBOS + "'").Length >=  0, AUDITTRAILTYPE.MSBOS);
			Assert.IsTrue(dsTest.Tables[0].Select(ARTIFICIAL.AuditType + "  =  '" + AUDITTRAILTYPE.Patient + "'").Length >=  0, AUDITTRAILTYPE.Patient);
			Assert.IsTrue(dsTest.Tables[0].Select(ARTIFICIAL.AuditType + "  =  '" + AUDITTRAILTYPE.ProductModifications + "'").Length >=  0, AUDITTRAILTYPE.ProductModifications);
			Assert.IsTrue(dsTest.Tables[0].Select(ARTIFICIAL.AuditType + "  =  '" + AUDITTRAILTYPE.QCConfiguration + "'").Length >=  0, AUDITTRAILTYPE.QCConfiguration);
			Assert.IsTrue(dsTest.Tables[0].Select(ARTIFICIAL.AuditType + "  =  '" + AUDITTRAILTYPE.ReagentInventoryLevel + "'").Length >=  0, AUDITTRAILTYPE.ReagentInventoryLevel);
			Assert.IsTrue(dsTest.Tables[0].Select(ARTIFICIAL.AuditType + "  =  '" + AUDITTRAILTYPE.TestingConfiguration + "'").Length >=  0, AUDITTRAILTYPE.TestingConfiguration);
			Assert.IsTrue(dsTest.Tables[0].Select(ARTIFICIAL.AuditType + "  =  '" + AUDITTRAILTYPE.TransfusionComplications + "'").Length >=  0, AUDITTRAILTYPE.TransfusionComplications);
			Assert.IsTrue(dsTest.Tables[0].Select(ARTIFICIAL.AuditType + "  =  '" + AUDITTRAILTYPE.TransfusionEffectiveness + "'").Length >=  0, AUDITTRAILTYPE.TransfusionEffectiveness);
			Assert.IsTrue(dsTest.Tables[0].Select(ARTIFICIAL.AuditType + "  =  '" + AUDITTRAILTYPE.TransfusionRequirement + "'").Length >=  0, AUDITTRAILTYPE.TransfusionRequirement);
			Assert.IsTrue(dsTest.Tables[0].Select(ARTIFICIAL.AuditType + "  =  '" + AUDITTRAILTYPE.UserAlerts + "'").Length >=  0, AUDITTRAILTYPE.UserAlerts);
			Assert.IsTrue(dsTest.Tables[0].Select(ARTIFICIAL.AuditType + "  =  '" + AUDITTRAILTYPE.Workload + "'").Length >=  0, AUDITTRAILTYPE.Workload);
		}

		/// <summary>
		/// Updates the table's LastUpdateUser field, for where the RecordGuid is the input value
		/// </summary>
		/// <param name = "tableName"></param>
		/// <param name = "fieldName"></param>
		/// <param name = "recordGuid"></param>
		/// <param name = "setFieldSQL">Field to update - for BOL Audit's to return data, some fields must have changed</param>
		private void PerformUpdate(string tableName, string fieldName, System.Guid recordGuid, string setFieldSQL)
		{
			if (setFieldSQL.Length > 0) setFieldSQL  =  ", " + setFieldSQL;

			string sqlText  =  "UPDATE " + tableName + " SET LastUpdateDate  =  GETUTCDATE(), LastUpdateUser  =  '" + Common.LogonUser.LogonUserName + "'" + setFieldSQL + " WHERE " + fieldName + "  =  '" + recordGuid.ToString() + "'";

			int retValue = UnitTestUtil.RunSQL(sqlText);

			if (retValue  ==  0)
			{
				throw new ArgumentException(sqlText + "-- No rows updated for audit to happen");
			}

			this.RefreshData  =  true;
		}

	}
}
#endif

